<?php
// test_websocket.php
// Run in terminal: php test_websocket.php

use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;
use Ratchet\Server\IoServer;
use Ratchet\Http\HttpServer;
use Ratchet\WebSocket\WsServer;

require 'vendor/autoload.php';

class Chat implements MessageComponentInterface {
    protected $clients;

    public function __construct() {
        $this->clients = new \SplObjectStorage;
        echo "WebSocket Server started! Listening on port 8080...\n";
    }

    public function onOpen(ConnectionInterface $conn) {
        $this->clients->attach($conn);
        echo "New client connected ({$conn->resourceId})\n";

        // Send welcome message to all
        foreach ($this->clients as $client) {
            $client->send("New user connected: {$conn->resourceId}");
        }
    }

    public function onMessage(ConnectionInterface $from, $msg) {
        echo "Message received: $msg\n";

        // Broadcast to all other clients
        foreach ($this->clients as $client) {
            if ($from !== $client) {
                $client->send("User {$from->resourceId}: $msg");
            }
        }
    }

    public function onClose(ConnectionInterface $conn) {
        $this->clients->detach($conn);
        echo "Client disconnected ({$conn->resourceId})\n";
    }

    public function onError(ConnectionInterface $conn, \Exception $e) {
        echo "Error: {$e->getMessage()}\n";
        $conn->close();
    }
}

// Start WebSocket Server
$server = IoServer::factory(
    new HttpServer(
        new WsServer(
            new Chat()
        )
    ),
    8080
);

echo "Server running → ws://YOUR_SERVER_IP:8080\n";
echo "Now open test.html in your browser!\n";

$server->run();
